/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.util.GenericNonValidatingParser;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLHelper
extends CommonXMLParser
implements ErrorHandler {
    private static final String TRACE_MASKT = "XPALXMLT";
    private static final String TRACE_MASKF = "XPALXMLF";
    private static final String TRACE_MASKD = "XPALXMLD";
    private static final String problemTag = "xframe-problem";
    private static final String mapTag = "map";
    private static final String TAG_MESSAGES = "MESSAGES";
    private static final String TAG_REFCODE = "REFCODE";
    private static final String TAG_MESSAGE_NUMBER = "MESSAGE_NUMBER";
    private static final String TAG_TRUE = "TRUE";
    public static final String PROBLEM_STATE_CREATED = "0";
    public static final String PROBLEM_STATE_OPENED = "1";
    public static final String PROBLEM_STATE_CLOSED = "2";
    public static final String CREATED = "CREATED";
    public static final String OPENED = "OPENED";
    public static final String CLOSED = "CLOSED";
    public static final String xmlProblemsFile = "/home/dovin/javahmc/linuxhmc/data/pa/problems.xml";
    public static final String xml2ProblemMap = "/home/dovin/javahmc/linuxhmc/data/pa/XML2ProblemMap.xml";

    public XMLHelper() throws SAXNotRecognizedException, SAXNotSupportedException {
        Trace.trace(TRACE_MASKD, "XMLHelper.ctor");
    }

    public static void poundNameValuesOut(NodeList elems, String pad) {
        String thisPad = "    " + pad;
        for (int i = 0; i < elems.getLength(); ++i) {
            int p;
            Node thisProblem = elems.item(i);
            if (thisProblem.hasChildNodes()) {
                if (thisProblem.getNodeType() == 1) {
                    System.out.println(thisPad + "name= " + thisProblem.getNodeName());
                }
                if (thisProblem.getNodeType() == 3) {
                    System.out.println(thisPad + "value= " + thisProblem.getNodeValue());
                }
                if (thisProblem.hasAttributes()) {
                    System.out.println(thisPad + "Nodes Attribute count" + thisProblem.getAttributes().getLength());
                    for (p = 0; p < thisProblem.getAttributes().getLength(); ++p) {
                        System.out.println(thisPad + thisProblem.getAttributes().item(p).getNodeName() + " value=" + thisProblem.getAttributes().item(p).getNodeValue());
                    }
                }
                XMLHelper.poundNameValuesOut(thisProblem.getChildNodes(), thisPad);
                continue;
            }
            if (thisProblem.getNodeType() != 1) continue;
            System.out.println(thisPad + "childless name= " + thisProblem.getNodeName());
            if (thisProblem.hasAttributes()) {
                System.out.println(thisPad + "Nodes Attribute count" + thisProblem.getAttributes().getLength());
                for (p = 0; p < thisProblem.getAttributes().getLength(); ++p) {
                    System.out.println(thisPad + thisProblem.getAttributes().item(p).getNodeName() + " value=" + thisProblem.getAttributes().item(p).getNodeValue());
                }
            }
            System.out.println(thisPad + "childless type= " + thisProblem.getNodeType());
            System.out.println(thisPad + "childless value= " + thisProblem.getNodeValue());
        }
    }

    public static String getRealValue(Node thisNode) {
        if (thisNode.hasChildNodes()) {
            return thisNode.getChildNodes().item(0).getNodeValue();
        }
        return new String();
    }

    public static Node getWorkSection(Node elem, String sectionToLookFor) {
        Node tempNode = null;
        if (elem.getNodeName().equals(sectionToLookFor)) {
            return elem;
        }
        for (int i = 0; i < elem.getChildNodes().getLength(); ++i) {
            Node workNode;
            if (elem.getChildNodes().item(i).getNodeName().equals(sectionToLookFor)) {
                return elem.getChildNodes().item(i);
            }
            if (!elem.getChildNodes().item(i).hasChildNodes() || (workNode = XMLHelper.getWorkSection(elem.getChildNodes().item(i), sectionToLookFor)) == null) continue;
            return workNode;
        }
        return tempNode;
    }

    public static String getAttributeValue(Node elem, String attr2look4) {
        String name = null;
        if (elem.hasAttributes()) {
            for (int i = 0; i < elem.getAttributes().getLength(); ++i) {
                if (!elem.getAttributes().item(i).getNodeName().equals(attr2look4)) continue;
                return elem.getAttributes().item(i).getNodeValue();
            }
        }
        return name;
    }

    public static void getServiceHistoryValues(Node elem, String xmlName, ArrayList values) {
        xmlName = "history-entry";
        if (elem.hasChildNodes()) {
            for (int i = 0; i < elem.getChildNodes().getLength(); ++i) {
                if (elem.getChildNodes().item(i).getNodeName().equals(xmlName)) {
                    values.add(new HistoryEntry());
                    HistoryEntry thisHistoryEntry = (HistoryEntry)values.get(values.size() - 1);
                    if (thisHistoryEntry == null) {
                        System.out.println("this historyEntry is null");
                    }
                    thisHistoryEntry.setHistory(Integer.parseInt(XMLHelper.getAttributeValue(elem.getChildNodes().item(i), "value")), XMLHelper.convertToDate(XMLHelper.getAttributeValue(elem.getChildNodes().item(i), "date")));
                }
                if (!elem.getChildNodes().item(i).hasChildNodes()) continue;
                XMLHelper.getServiceHistoryValues(elem.getChildNodes().item(i), xmlName, values);
            }
        }
    }

    public static ArrayList getServiceHistoryValues(Node elem) {
        ArrayList<HistoryEntry> values = new ArrayList<HistoryEntry>();
        String xmlName = "history-entry";
        if (elem.hasChildNodes()) {
            for (int i = 0; i < elem.getChildNodes().getLength(); ++i) {
                if (elem.getChildNodes().item(i).getNodeName().equals(xmlName)) {
                    values.add(new HistoryEntry());
                    HistoryEntry thisHistoryEntry = (HistoryEntry)values.get(values.size() - 1);
                    if (thisHistoryEntry == null) {
                        System.out.println("this historyEntry is null");
                    }
                    thisHistoryEntry.setHistory(Integer.parseInt(XMLHelper.getAttributeValue(elem.getChildNodes().item(i), "value")), XMLHelper.convertToDate(XMLHelper.getAttributeValue(elem.getChildNodes().item(i), "date")));
                }
                if (!elem.getChildNodes().item(i).hasChildNodes()) continue;
                values.addAll(XMLHelper.getServiceHistoryValues(elem.getChildNodes().item(i)));
            }
        }
        return values;
    }

    private static int getMethodIndex(Method[] methods, String nameToMatch, String prefix) {
        int index = -1;
        for (int b = 0; b < methods.length; ++b) {
            if (methods[b].getName().toLowerCase().indexOf((prefix + nameToMatch).toLowerCase()) == -1) continue;
            Class<?>[] parameterTypes = methods[b].getParameterTypes();
            return b;
        }
        return index;
    }

    public static Date convertToDate(String dateStr) {
        Date myDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd kk:mm:ss zzz yyyy");
        try {
            myDate = sdf.parse(dateStr);
            System.out.println("myDate parsed out = " + myDate.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return myDate;
    }

    public static Method getMyMethod(Object obj, String name, Class[] parmTypes) {
        Method returnMethod = null;
        try {
            returnMethod = obj.getClass().getMethod(name, parmTypes);
        }
        catch (Exception e) {
            // empty catch block
        }
        return returnMethod;
    }

    public static String[] getAllChildrenWithName(Node node2WorkWith, String keyName) {
        String[] returnString = new String[]{};
        ArrayList<String> ourValues = new ArrayList<String>();
        if (node2WorkWith != null) {
            for (int i = 0; i < node2WorkWith.getChildNodes().getLength(); ++i) {
                Node thisElement = node2WorkWith.getChildNodes().item(i);
                if (!thisElement.getNodeName().equals(keyName)) continue;
                ourValues.add(XMLHelper.getRealValue(thisElement));
            }
        }
        if (ourValues.size() > 0) {
            return (String[])ourValues.toArray();
        }
        return returnString;
    }

    public static ArrayList getAllChildrenWithNameValues(Node node2WorkWith, String keyName) {
        ArrayList<String> ourValues = new ArrayList<String>();
        if (node2WorkWith != null) {
            for (int i = 0; i < node2WorkWith.getChildNodes().getLength(); ++i) {
                Node thisElement = node2WorkWith.getChildNodes().item(i);
                if (!thisElement.getNodeName().equals(keyName)) continue;
                ourValues.add(XMLHelper.getRealValue(thisElement));
            }
        }
        return ourValues;
    }

    public static ArrayList getAttrValuesForAllChildrenWithNameWithKey(Node node2WorkWith, String keyName, String key) {
        ArrayList<String> ourValues = new ArrayList<String>();
        if (node2WorkWith != null) {
            for (int i = 0; i < node2WorkWith.getChildNodes().getLength(); ++i) {
                Node thisElement = node2WorkWith.getChildNodes().item(i);
                if (!thisElement.getNodeName().equals(keyName)) continue;
                ourValues.add(XMLHelper.getAttributeValue(thisElement, key));
            }
        }
        return ourValues;
    }

    public static String createTag(Class type, String tagName) {
        String className = new String();
        className = type.getName().indexOf("Boolean") != -1 ? "z" : (type.getName().indexOf("Byte") != -1 ? "b" : (type.getName().indexOf("Char") != -1 ? "c" : (type.getName().indexOf("Short") != -1 ? "s" : (type.getName().indexOf("Integer") != -1 ? "i" : (type.getName().indexOf("Long") != -1 ? "j" : (type.getName().indexOf("Float") != -1 ? "f" : (type.getName().indexOf("Double") != -1 ? "d" : (type.getName().indexOf("String") != -1 ? "t" : (type.getName().indexOf("boolean") != -1 ? "Z" : (type.getName().indexOf("byte") != -1 ? "B" : (type.getName().indexOf("char") != -1 ? "C" : (type.getName().indexOf("short") != -1 ? "S" : (type.getName().indexOf("int") != -1 ? "I" : (type.getName().indexOf("long") != -1 ? "J" : (type.getName().indexOf("float") != -1 ? "F" : (type.getName().indexOf("double") != -1 ? "D" : (type.getName().indexOf("string") != -1 ? "T" : "L" + type.getName())))))))))))))))));
        return "<" + tagName + " class=\"" + className + "\">";
    }

    public static String createTag(Object obj, String tagName) {
        String className = new String();
        className = "L" + obj.getClass().getName();
        return "<" + tagName + " class=\"" + className + "\">";
    }

    public static String createClassTag(Object thisObj) {
        String className = new String();
        className = thisObj.getClass().getName().indexOf("Boolean") != -1 ? "z" : (thisObj.getClass().getName().indexOf("Byte") != -1 ? "b" : (thisObj.getClass().getName().indexOf("Char") != -1 ? "c" : (thisObj.getClass().getName().indexOf("Short") != -1 ? "s" : (thisObj.getClass().getName().indexOf("Integer") != -1 ? "i" : (thisObj.getClass().getName().indexOf("Long") != -1 ? "j" : (thisObj.getClass().getName().indexOf("Float") != -1 ? "f" : (thisObj.getClass().getName().indexOf("Double") != -1 ? "d" : "l" + thisObj.getClass().getName())))))));
        return " class=\"" + className + "\"";
    }

    public static String createTag(Class classOfObj) {
        String className = new String();
        className = "L" + classOfObj.getName();
        return "<" + classOfObj.getName().substring(classOfObj.getName().lastIndexOf(".") + 1) + " class=\"" + className + "\">\n";
    }

    public static String createClassTag(String className) {
        className = "L" + className;
        return " class=\"" + className + "\"";
    }

    public static void getValueNativeObject(Node valueNode, Field fieldToChange, Object aObject) {
        String className = new String();
        Class<?> vClass = null;
        Object vObject = null;
        String classType = new String();
        int index = 0;
        boolean array = false;
        boolean done = false;
        if (valueNode == null) {
            return;
        }
        if (valueNode.hasAttributes() && (classType = XMLHelper.getAttributeValue(valueNode, "class")) != null) {
            block64: {
                if (classType.charAt(index) == '[') {
                    array = true;
                    ++index;
                }
                try {
                    Object[] methodParms;
                    Method method;
                    String methodName;
                    Class[] classParms;
                    if (classType.charAt(index) == 'Z') {
                        fieldToChange.setAccessible(true);
                        classParms = new Class[]{fieldToChange.getType()};
                        methodName = "set" + fieldToChange.getName().substring(0, 1).toUpperCase() + fieldToChange.getName().substring(1);
                        method = XMLHelper.getMyMethod(aObject, methodName, classParms);
                        if (method != null) {
                            methodParms = new Object[]{Boolean.valueOf(XMLHelper.getRealValue(valueNode))};
                            method.invoke(aObject, methodParms);
                        } else {
                            System.out.println("No Method found for " + methodName + "\n");
                        }
                        done = true;
                    } else if (classType.charAt(index) == 'C') {
                        fieldToChange.setAccessible(true);
                        classParms = new Class[]{fieldToChange.getType()};
                        methodName = "set" + fieldToChange.getName().substring(0, 1).toUpperCase() + fieldToChange.getName().substring(1);
                        method = XMLHelper.getMyMethod(aObject, methodName, classParms);
                        if (method != null) {
                            methodParms = new Object[]{XMLHelper.getRealValue(valueNode)};
                            method.invoke(aObject, methodParms);
                            fieldToChange.setChar(fieldToChange, XMLHelper.getRealValue(valueNode).charAt(0));
                        } else {
                            System.out.println("No Method found for " + methodName + "\n");
                        }
                        done = true;
                    } else if (classType.charAt(index) == 'S') {
                        fieldToChange.setAccessible(true);
                        classParms = new Class[]{fieldToChange.getType()};
                        methodName = "set" + fieldToChange.getName().substring(0, 1).toUpperCase() + fieldToChange.getName().substring(1);
                        method = XMLHelper.getMyMethod(aObject, methodName, classParms);
                        if (method != null) {
                            methodParms = new Object[]{new Short(XMLHelper.getRealValue(valueNode))};
                            method.invoke(aObject, methodParms);
                        } else {
                            System.out.println("No Method found for " + methodName + "\n");
                        }
                        done = true;
                    } else if (classType.charAt(index) == 'I') {
                        fieldToChange.setAccessible(true);
                        classParms = new Class[]{fieldToChange.getType()};
                        methodName = "set" + fieldToChange.getName().substring(0, 1).toUpperCase() + fieldToChange.getName().substring(1);
                        method = XMLHelper.getMyMethod(aObject, methodName, classParms);
                        if (method != null) {
                            methodParms = new Object[]{new Integer(XMLHelper.getRealValue(valueNode))};
                            method.invoke(aObject, methodParms);
                        } else {
                            System.out.println("No Method found for " + methodName + "\n");
                        }
                        done = true;
                    } else if (classType.charAt(index) == 'J') {
                        fieldToChange.setAccessible(true);
                        classParms = new Class[]{fieldToChange.getType()};
                        methodName = "set" + fieldToChange.getName().substring(0, 1).toUpperCase() + fieldToChange.getName().substring(1);
                        method = XMLHelper.getMyMethod(aObject, methodName, classParms);
                        if (method != null) {
                            methodParms = new Object[]{new Long(XMLHelper.getRealValue(valueNode))};
                            method.invoke(aObject, methodParms);
                        } else {
                            System.out.println("No Method found for " + methodName + "\n");
                        }
                        done = true;
                    } else if (classType.charAt(index) == 'F') {
                        fieldToChange.setAccessible(true);
                        classParms = new Class[]{fieldToChange.getType()};
                        methodName = "set" + fieldToChange.getName().substring(0, 1).toUpperCase() + fieldToChange.getName().substring(1);
                        method = XMLHelper.getMyMethod(aObject, methodName, classParms);
                        if (method != null) {
                            methodParms = new Object[]{new Float(XMLHelper.getRealValue(valueNode))};
                            method.invoke(aObject, methodParms);
                        } else {
                            System.out.println("No Method found for " + methodName + "\n");
                        }
                        done = true;
                    } else if (classType.charAt(index) == 'D') {
                        fieldToChange.setAccessible(true);
                        classParms = new Class[]{fieldToChange.getType()};
                        methodName = "set" + fieldToChange.getName().substring(0, 1).toUpperCase() + fieldToChange.getName().substring(1);
                        method = XMLHelper.getMyMethod(aObject, methodName, classParms);
                        if (method != null) {
                            methodParms = new Object[]{new Double(XMLHelper.getRealValue(valueNode))};
                            method.invoke(aObject, methodParms);
                        } else {
                            System.out.println("No Method found for " + methodName + "\n");
                        }
                        done = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (done) {
                    return;
                }
                if (classType.charAt(index) == 'z') {
                    vObject = Boolean.valueOf(XMLHelper.getRealValue(valueNode));
                } else if (classType.charAt(index) == 'c') {
                    vObject = new Character(XMLHelper.getRealValue(valueNode).charAt(0));
                } else if (classType.charAt(index) == 's') {
                    vObject = new Short(XMLHelper.getRealValue(valueNode));
                } else if (classType.charAt(index) == 'i') {
                    vObject = new Integer(XMLHelper.getRealValue(valueNode));
                } else if (classType.charAt(index) == 'j') {
                    vObject = new Long(XMLHelper.getRealValue(valueNode));
                } else if (classType.charAt(index) == 'f') {
                    vObject = new Float(XMLHelper.getRealValue(valueNode));
                } else if (classType.charAt(index) == 'd') {
                    vObject = new Double(XMLHelper.getRealValue(valueNode));
                } else if (classType.charAt(index) == 'L') {
                    try {
                        vClass = Class.forName(classType.substring(1));
                        Class[] constructorParms = new Class[]{};
                        Constructor<?> nullCons = null;
                        try {
                            nullCons = vClass.getConstructor(constructorParms);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (nullCons == null) break block64;
                        vObject = vClass.newInstance();
                        if (vObject instanceof XMLEncodeable) {
                            ((XMLEncodeable)vObject).fromXML(valueNode);
                            break block64;
                        }
                        Class[] strConstructorParm = new Class[]{XMLHelper.getRealValue(valueNode).getClass()};
                        Constructor<?> thisClassCons = null;
                        try {
                            thisClassCons = vClass.getConstructor(strConstructorParm);
                        }
                        catch (Exception e) {
                            System.out.println("no such contructor for this class = " + vClass.getName());
                        }
                        if (thisClassCons != null) {
                            Object[] newInstanceParms = new Object[]{XMLHelper.getRealValue(valueNode)};
                            vObject = thisClassCons.newInstance(newInstanceParms);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    vObject = classType.charAt(index) == 't' ? XMLHelper.convertFormattedString(XMLHelper.getRealValue(valueNode)) : XMLHelper.getRealValue(valueNode);
                }
            }
            try {
                fieldToChange.setAccessible(true);
                if (vObject != null) {
                    if (vClass == null) {
                        fieldToChange.set(aObject, vObject);
                    } else if (vClass.getName().indexOf("Persistable") == -1) {
                        fieldToChange.set(aObject, vObject);
                    } else {
                        fieldToChange.set(aObject, (Persistable)vObject);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isJavaType(Node valueNode) {
        int index = 0;
        boolean array = false;
        String classType = new String();
        if (valueNode.hasAttributes() && (classType = XMLHelper.getAttributeValue(valueNode, "class")) != null) {
            if (classType.charAt(index) == '[') {
                array = true;
                ++index;
            }
            if (classType.charAt(index) == 'z' || classType.charAt(index) == 'c' || classType.charAt(index) == 's' || classType.charAt(index) == 'i' || classType.charAt(index) == 'j' || classType.charAt(index) == 'f' || classType.charAt(index) == 'd' || classType.charAt(index) == 'l') {
                return true;
            }
        }
        return false;
    }

    public static boolean isJavaType(Field field) {
        boolean index = false;
        boolean array = false;
        String classType = new String();
        Class<?> type = field.getType();
        String className = new String();
        return type.getName().indexOf("boolean") == -1 && type.getName().indexOf("byte") == -1 && type.getName().indexOf("char") == -1 && type.getName().indexOf("short") == -1 && type.getName().indexOf("int") == -1 && type.getName().indexOf("long") == -1 && type.getName().indexOf("float") == -1 && type.getName().indexOf("double") == -1 && type.getName().indexOf("string") == -1;
    }

    public static boolean isJavaObject(Field field) {
        boolean index = false;
        boolean array = false;
        String classType = new String();
        Class<?> type = field.getType();
        String className = new String();
        return type.getName().indexOf("boolean") == -1 && type.getName().indexOf("byte") == -1 && type.getName().indexOf("char") == -1 && type.getName().indexOf("short") == -1 && type.getName().indexOf("int") == -1 && type.getName().indexOf("long") == -1 && type.getName().indexOf("float") == -1 && type.getName().indexOf("double") == -1 && type.getName().indexOf("string") == -1 && type.getName().indexOf("Boolean") == -1 && type.getName().indexOf("Byte") == -1 && type.getName().indexOf("Char") == -1 && type.getName().indexOf("Short") == -1 && type.getName().indexOf("Integer") == -1 && type.getName().indexOf("Long") == -1 && type.getName().indexOf("Float") == -1 && type.getName().indexOf("Double") == -1 && type.getName().indexOf("String") == -1;
    }

    public static void rebuildObject(Object thisObject, Node valueNode) {
        boolean index = false;
        boolean array = false;
        Trace.trace(TRACE_MASKD, "--> rebuildObject");
        Field[] fields = null;
        Node classNode = null;
        for (Class<?> thisObjClass = thisObject.getClass(); thisObjClass != null; thisObjClass = thisObjClass.getSuperclass()) {
            String className = thisObjClass.getName().substring(thisObjClass.getName().lastIndexOf(".") + 1);
            classNode = XMLHelper.getWorkSection(valueNode, className);
            if (classNode == null) {
                Trace.trace(TRACE_MASKT, "<-- rebuildObject: no node for " + className + " found");
                return;
            }
            fields = thisObjClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                int modifiers = fields[i].getModifiers();
                if ((modifiers & 0x10) == 16 || (modifiers & 8) == 8) continue;
                Node node = XMLHelper.getWorkSection(classNode, fields[i].getName());
                if (node != null) {
                    XMLHelper.getValueNativeObject(node, fields[i], thisObject);
                    continue;
                }
                Trace.trace(TRACE_MASKD, "no node for field " + fields[i].getName() + " found");
            }
            fields = null;
        }
        Trace.trace(TRACE_MASKD, "<-- rebuildObject");
    }

    public static Object rebuildObject(String xmlString, String xmlTag) throws HException {
        Trace.trace(TRACE_MASKD, "--> rebuildObject(String,String)");
        Trace.trace(TRACE_MASKD, "    (" + xmlString + "," + xmlTag + ")");
        Object newObj = null;
        try {
            NodeList xmlNodeList = GenericNonValidatingParser.parseXML(xmlString, xmlTag);
            if (xmlNodeList.item(0).hasAttributes() && XMLHelper.getAttributeValue(xmlNodeList.item(0), "class") != null) {
                Class<?> objClass = Class.forName(XMLHelper.getAttributeValue(xmlNodeList.item(0), "class").substring(1));
                Class[] parms = new Class[]{};
                Constructor<?> objCons = objClass.getConstructor(parms);
                objCons.setAccessible(true);
                Object[] objs = new Object[]{};
                newObj = objCons.newInstance(objs);
                XMLHelper.rebuildObject(newObj, xmlNodeList.item(0));
            } else {
                Trace.trace(TRACE_MASKT, "Invalid XML");
            }
        }
        catch (Exception e) {
            throw new HException(e);
        }
        Trace.trace(TRACE_MASKD, "<-- rebuildObject");
        return newObj;
    }

    public static void outToXML(Object aObject, StringBuffer sb, Class aClass) {
        boolean index = false;
        boolean array = false;
        Field[] fields = null;
        Object superClass = null;
        String baseClassName = null;
        baseClassName = aClass.getName().substring(aClass.getName().lastIndexOf(".") + 1);
        sb.append("<" + baseClassName + " class=\"L" + aClass.getName() + "\">\n");
        fields = aClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            int modifier = fields[i].getModifiers();
            if ((modifier & 0x10) == 16) continue;
            Trace.trace(TRACE_MASKD, "field: " + fields[i].getName() + " value = " + fields[i].toString());
            fields[i].setAccessible(true);
            try {
                Object fieldObj = fields[i].get(aObject);
                if (fieldObj == null) continue;
                Trace.trace(TRACE_MASKD, " received fieldObj)" + fields[i].getName() + " from our object  ");
                sb.append(XMLHelper.createTag(fieldObj.getClass(), fields[i].getName()));
                if (fieldObj instanceof XMLEncodeable) {
                    Trace.trace(TRACE_MASKD, " field" + fields[i].getName() + " was xmlencodeable  ");
                    ((XMLEncodeable)fieldObj).toXML(sb);
                } else {
                    Trace.trace(TRACE_MASKD, " field" + fields[i].getName() + " not xmlencodeable  ");
                    if (fields[i].getType().getName().indexOf("[", 0) != -1) {
                        for (int y = 0; y < Array.getLength(fields[i]); ++y) {
                            sb.append(Array.get(fieldObj, y).toString());
                            if (y >= Array.getLength(fields[i]) - 1) continue;
                            sb.append(",");
                        }
                    } else {
                        if (fieldObj.getClass().getName().indexOf("String") != -1) {
                            sb.append(XMLHelper.convertRawString(fieldObj));
                        }
                        sb.append(fieldObj.toString());
                    }
                }
                sb.append("</" + fields[i].getName() + ">\n");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (aClass.getSuperclass() != null) {
            XMLHelper.outToXML(aObject, sb, aClass.getSuperclass());
        }
        sb.append("</" + baseClassName + ">\n");
    }

    private static String convertRawString(Object fieldObj) {
        StringBuffer returnStrBuf = new StringBuffer();
        String holderString = (String)fieldObj;
        if (fieldObj.getClass().getName().equals("StringBuffer")) {
            holderString = fieldObj.toString();
        }
        System.out.println("workString = " + holderString);
        for (int i = 0; i < holderString.length(); ++i) {
            Character thisChar = new Character(holderString.charAt(i));
            if (Character.isIdentifierIgnorable(thisChar.charValue())) continue;
            if (thisChar.charValue() == '&') {
                String remainder = holderString.substring(i);
                if (remainder.indexOf("&lt;") == 0 || remainder.indexOf("&gt;") == 0) {
                    returnStrBuf.append(holderString.substring(i, i + 4));
                    i += 3;
                    continue;
                }
                if (remainder.indexOf("&quot;") == 0) {
                    returnStrBuf.append(holderString.substring(i, i + 6));
                    i += 5;
                    continue;
                }
                if (remainder.indexOf("&amp;") == 0) {
                    returnStrBuf.append(holderString.substring(i, i + 5));
                    i += 4;
                    continue;
                }
                returnStrBuf.append("&amp;");
                continue;
            }
            switch (thisChar.charValue()) {
                case '<': {
                    returnStrBuf.append("&lt;");
                }
                case '>': {
                    returnStrBuf.append("&gt;");
                }
                case '\"': {
                    returnStrBuf.append("&quot;");
                }
            }
            returnStrBuf.append(thisChar);
        }
        return returnStrBuf.toString();
    }

    private static String convertFormattedString(Object fieldObj) {
        StringBuffer returnStrBuf = new StringBuffer();
        String holderString = (String)fieldObj;
        if (fieldObj.getClass().getName().equals("StringBuffer")) {
            holderString = fieldObj.toString();
        }
        System.out.println("workString = " + holderString);
        for (int i = 0; i < holderString.length(); ++i) {
            Character thisChar = new Character(holderString.charAt(i));
            if (Character.isIdentifierIgnorable(thisChar.charValue())) continue;
            if (thisChar.charValue() == '&') {
                String remainder = holderString.substring(i);
                if (remainder.indexOf("&lt;") == 0) {
                    returnStrBuf.append('<');
                    i += 3;
                    continue;
                }
                if (remainder.indexOf("&gt;") == 0) {
                    returnStrBuf.append('>');
                    i += 3;
                    continue;
                }
                if (remainder.indexOf("&quot;") == 0) {
                    returnStrBuf.append('\"');
                    i += 5;
                    continue;
                }
                if (remainder.indexOf("&amp;") == 0) {
                    returnStrBuf.append('&');
                    i += 4;
                    continue;
                }
                returnStrBuf.append(thisChar);
                continue;
            }
            returnStrBuf.append(thisChar);
        }
        return returnStrBuf.toString();
    }

    public static void outPutField(Object aObject, StringBuffer sb, Class aClass) {
        Field[] fields = aClass.getFields();
        String baseClassName = aClass.getName().substring(aClass.getName().lastIndexOf(".") + 1);
        fields = aClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].getModifiers();
            if ((fields[i].getModifiers() & 0x10) == 16) continue;
            fields[i].setAccessible(true);
            try {
                Object fieldObj = fields[i].get(aObject);
                if (fieldObj == null) continue;
                sb.append(XMLHelper.createTag(fields[i].getType(), fields[i].getName()));
                Field[] fieldFields = fieldObj.getClass().getFields();
                if (fieldFields.length > 0) {
                    for (int x = 0; x < fieldFields.length; ++x) {
                        XMLHelper.outPutField(fieldFields[x].get(fieldObj), sb, fieldFields[x].get(fieldObj).getClass());
                    }
                } else if (XMLHelper.isJavaType(fields[i])) {
                    sb.append(fieldObj.toString());
                } else {
                    sb.append(fieldObj);
                }
                sb.append("</" + fields[i].getName() + ">\n");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String convertQuote(String in) {
        if (in == null) {
            return null;
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            if (in.substring(i, i + 1).equals("\"")) {
                out.append("&quot;");
                continue;
            }
            out.append(new char[]{in.charAt(i)});
        }
        return out.toString();
    }

    public static String unconvertQuote(String in) {
        if (in == null) {
            return null;
        }
        String out = in;
        while (out.indexOf("&quot;") > 0) {
            out = out.substring(0, out.indexOf("&quot;")) + "\"" + out.substring(out.indexOf("&quot;") + 6);
        }
        return out;
    }

    public static void main(String[] args) {
        String in = "com.ibm.hsc.ccfw.mom.PICec[SerialNumber=\"100072A\", Model=\"520\", MachineType=\"9111\"]";
        System.out.println("in=" + in);
        String out = XMLHelper.convertQuote(in);
        System.out.println("out=" + out);
        System.out.println("back in=" + XMLHelper.unconvertQuote(out));
        System.out.println("equals? " + in.equals(XMLHelper.unconvertQuote(out)));
    }
}

